//############################################################################//
//             Copyright (c) 2006, by Deluxe-Menu.com
//             Deluxe Tuner script
//             http://deluxe-menu.com
//             Programming by Shakhmatov Nik
//             E-mail: cs@deluxe-menu.com
//############################################################################//

var dm_tunerParams = [

  ['Common','section','icon_common','1'],
    ['isHorizontal',  'boolean', '1', 'Menu orientation: 0 - vertical, 1 - horizontal.'],
    ['smColumns',     'integer-nn', '1', 'Number of columns in submenus.'],
    ['smOrientation', 'boolean', '0', 'Orientation of submenu: 0 - vertical (default), 1 - horizontal.'],
    ['smViewType',    'integer-nn', '0', 'The way of showing the menu.>>0 - from left to right,>>1 - from left to right + upwards,>>2 - from right to left,>>3 - from right to left + upwards (e.g. for right-to-left languages).'],
    ['dmRTL',         'boolean', '0', 'Set this parameter to 1 if you\'re using right-to-left direction of html page (dir=rtl).>>Default is 0.>>Use also smViewType parameter for right-to-left languages.'],

    ['','separator','',''],

    ['pressedItem', 'integer', '-2', 'The toggle mode.>>Sets an index of an item that will be highlighted by default.>>-2 - the toggle mode is disabled;>>-1 - the toggle mode is enabled, but no items highlighted by default;>>0,1,2,3,... - index of highlighted item in a top-menu.'],
    ['itemCursor',  'set', 'default,auto,crosshair,pointer,move,text,wait,help,n-resize,ne-resize,nw-resize,s-resize,se-resize,sw-resize,e-resize,w-resize', 'Items cursor.'],
    ['itemTarget',  'set-add', '_self,_blank,_top,_parent,_search', 'Default target for all menu items.>>You can also set a frame name.'],

    ['', 'separator', '', ''],

    ['statusString', 'set-add', 'link,text,tip', 'Text in a browser\'s status bar when you put a pointer over an item.>>Value \'link\' shows an item link.>>Value \'text\' shows an item text.>>Value \'tip\' shows an item tip.>>With another value shows specified value.'],
    ['blankImage',   'image',   'blank image filename', 'Path to a blank image. Usually it\'s a GIF image with a transparent background, size 1x1 px.'],


  ['Dimensions','section','icon_dimensions',''],
    ['menuWidth',  'integer-percent', '',  'Width of the menu in px, % or other units.>>It\'s recommended to assign a precise value to this parameter for a correct menu positioning in different browsers.'],
    ['menuHeight', 'integer-percent', '',  'Height of the menu in px.>>It\'s recommended to write \'px\' at the end of value.'],
    ['smWidth',    'integer-percent', '',  'Width of all submenus.'],
    ['smHeight',   'integer-percent', '',  'Height of all submenus.'],
    

  ['Positioning','section','icon_positioning',''],
    ['absolutePos', 'boolean','0','Sets absolute menu position.>>0 - relative positioning (for example, menu can be placed inside a table)>>1 - absolute positioning (menu uses absolute coordinates on page).'],
    ['posX', 'integer-percent','0','X coordinate of top-left menu corner.'],
    ['posY', 'integer-percent','0','Y coordinate of top-left menu corner.'],

    ['','separator','',''],

    ['topDX', 'integer', '0',  'X offset for 1st-level submenus.'],
    ['topDY', 'integer', '0',  'Y offset for 1st-level submenus.'],
    ['DX',    'integer', '0', 'X offset for submenus.'],
    ['DY',    'integer', '0',  'Y offset for submenus.'],

  ['Font','section','icon_font',''],
    ['fontStyle',      'font',        'normal 11px Trebuchet MS, Tahoma, Arial',    'Font style.'],
    ['fontColor',      'color-array', ['#000000','#FFFFFF'], 'Normal and mouseover font colors.'],
    ['fontDecoration', 'set-array',   ['none,underline,line-through,overline','none,underline,line-through,overline'], 'Normal and mouseover font decorations.'],
    ['fontColorDisabled', 'color', '#AAAAAA', 'Font color for a disabled item.>>The item is disabled when its target is \'_\''],

  ['Appearance','section','icon_appearance',''],
    ['menuBackColor',  'color', '#FFFFFF', 'Background color of the menu and all submenus.'],
    ['menuBackImage',  'image', '', 'Background image for the menu and all the submenus.'],
    ['menuBackRepeat', 'set', 'repeat,repeat-x,repeat-y,no-repeat', 'Repeating of background of the menu and all the submenus.'],

    ['','separator','',''],

    ['menuBorderColor',  'color',      '#999999',  'Border color of the menu and all the submenus.'],
    ['menuBorderWidth',  'integer-nn', '1', 'Border width for the menu and all the submenus.'],
    ['menuBorderStyle',  'set', 'solid,none,double,dotted,dashed,groove,ridge', 'Border style for the menu and all the submenus.'],

  ['Item Appearance','section','icon_item_appearance',''],
    ['itemBackColor', 'color-array', ['#FFFFFF','#4792E6'], 'Normal and mouseover background colors of items.'],
    ['itemBackImage', 'image-array', ['',''], 'Normal and mouseover background images of items.'],

    ['itemBorderWidth', 'integer-nn', '0', 'Width of items\' border.'],
    ['itemBorderColor', 'color-array', ['#6655FF','#665500'], 'Normal and mouseover border colors.'],
    ['itemBorderStyle', 'set-array',   ['none,solid,double,dotted,dashed,groove,ridge','none,solid,double,dotted,dashed,groove,ridge'], 'Normal and mouseover styles of items\' border.'],

    ['','separator','',''],
    
    ['itemSpacing',  'integer-nn', '1', 'Item spacing.'],
    ['itemPadding',  'integer-percent', '3px', 'Item padding.>>You can also set multiple values, for example:>>\'10px 15px 10px 5px\';>>(top, right, bottom, left).'],
    ['itemAlignTop', 'set', 'left,center,right',  'Text alignment for top items.'],
    ['itemAlign',    'set', 'left,center,right',  'Text alignment for submenu items.'],
    ['subMenuAlign', 'set', 'left,center,right', 'Submenus alignment.'],

  ['Icons','section','icon_icons',''],
    ['iconTopWidth', 'integer-nn','24','Width of icons for top-level items.'],
    ['iconTopHeight','integer-nn','24','Height of icons for top-level items.'],
    ['iconWidth', 'integer-nn','16','Width of icons for submenu items.'],
    ['iconHeight','integer-nn','16','Height of icons for submenu items.'],

    ['','separator','',''],

    ['arrowWidth',  'integer-nn', '9', 'Width of arrow icons.'],
    ['arrowHeight', 'integer-nn', '9', 'Height of arrow icons.'],
    ['arrowImageMain', 'image-array', ['',''], 'Normal and mouseover arrow images for top-level items.'],
    ['arrowImageSub',  'image-array', ['',''], 'Normal and mouseover arrow images for submenu items.'],

  ['Separators','section','icon_separators',''],
    ['separatorImage',     'image',           '',                  'Separator\'s image.'],
    ['separatorWidth',     'integer-percent', '100%',              'Width of a horizontal separator (in px, %).'],
    ['separatorHeight',    'integer-percent', '3',                 'Height of a horizontal separator (in px).'],
    ['separatorAlignment', 'set',             'left,center,right', 'Alignment of a horizontal separator.'],

    ['','separator','',''],

    ['separatorVImage',  'image',           '',     'Vertical separator\'s image.'],
    ['separatorVWidth',  'integer-percent', '3',    'Width of a vertical separator (in px).'],
    ['separatorVHeight', 'integer-percent', '100%', 'Height of a vertical separator (in px, %).'],
    
    ['','separator','',''],

    ['separatorPadding',  'integer-percent', '0px', 'Separators\' padding.>>You can also set multiple values, for example:>>\'10px 15px 10px 5px\';>>(top, right, bottom, left).'],

  ['Floatable Menu','section','icon_floatable',''],
    ['floatable',      'boolean',    '0', 'Creates a floatable menu - when the page is scrolled the menu remains visible.>>0 - disabled, 1 - enabled.'],
    ['floatIterations','integer-nn', '6', 'Sets a floatation speed.>>The less the value is the more the speed is.'],
    ['floatableX',     'boolean',    '1', 'Set a floatable ability for the menu along X axe.>>0 - disabled, 1 - enabled (default).'],
    ['floatableY',     'boolean',    '1', 'Set a floatable ability for the menu along Y axe.>>0 - disabled, 1 - enabled (default).'],


  ['Movable Menu','section','icon_movable',''],
    ['movable',    'boolean','0','Creates a movable menu - you can use a mouse to move a menu as a usual window.'],
    ['moveWidth',  'integer-nn', '12', 'Width of the drag spacer.'],
    ['moveHeight', 'integer-nn', '20', 'Height of the drag spacer.'],
    ['moveColor',  'color',      '#AA0000', 'Background color of the drag spacer.'],
    ['moveImage',  'image','','Image of the drag spacer.'],
    ['moveCursor', 'set', 'default,auto,crosshair,pointer,move,text,wait,help,n-resize,ne-resize,nw-resize,s-resize,se-resize,sw-resize,e-resize,w-resize', 'Cursor type when you mouseover the drag spacer.'],

    ['','separator','',''],

    ['smMovable',  'boolean', '0', 'Enables MS Office toolbar-like mode - you can drag submenus and separate them from the parent ones.'],
    ['closeBtnW',  'integer-nn', '15', 'Width of a close-button for submenus..'],
    ['closeBtnH',  'integer-nn', '15', 'Height of a close-button for submenus..'],
    ['closeBtn',   'image',   '',  'Image for a close-button for submenus.'],


  ['Transitional Effects & Filters', 'section', 'icon_effects',''],
    ['transparency',   'percent', '100', 'Transparency of submenu in %.'],
    ['transition',     'effect',  '24',  'Index of a transitional effect.'],
    ['transOptions',   'string',  '',    'Additional parameters for transitional effects.>>These options are applied for effects with index higher than 24.', '../../help/transitions.html'],
    ['transDuration',  'integer', '300', 'Delay of a transitional effect (in ms) on submenu\'s showing.'],
    ['transDuration2', 'integer', '200', 'Delay of a transitional effect (in ms) on submenu\'s hiding.'],

    ['','separator','',''],

    ['shadowLen',   'integer-nn', '3',       'Length of a shadow.'],
    ['shadowColor', 'color',      '#777777', 'Shadow color.'],
    ['shadowTop',   'boolean',    '1',       'A shadow for a top-menu: 0 - disabled, 1 - enabled.'],


  ['CSS Support (CSS-based Menu)', 'section', 'icon_css_mode',''],
    ['cssStyle',    'boolean', '0', 'Enables CSS mode.>>CSS mode allows you to use your own CSS styles for all components of the menu.>>0 - disabled (default), 1 - enabled.>>CSS mode won\'t work in Deluxe Tuner, you can only set class names here. You should create the page with CSS styles and test the menu within this page.'],
    ['cssSubmenu',  'string',  '',  'CSS class name for submenus.'],
    ['cssItem',     'string-array',  ['',''],  'Normal and mouseover CSS class names for items.'],
    ['cssItemText', 'string-array',  ['',''],  'Normal and mouseover CSS class names for a text of items.'],

  ['Advanced','section','icon_special',''],
    ['dmObjectsCheck', 'boolean', '0', 'Checking of intersection with selects, iframes, flash movies, etc.>>0 - disabled (default), 1 - enabled.'],

    ['saveNavigationPath', 'boolean', '1', 'The menu keeps items highlighted during menu navigation.>>0 - disabled, 1 - enabled (default).'],
    ['showByClick',        'boolean', '0', 'Show submenus on a mouse click only.>>0 - disabled (default), 1 - enabled.'],
    ['noWrap',             'boolean', '1', 'A wordwrap for items\' text.>>0 - disabled, 1 - enabled (default).'],

    ['','separator','',''],

    ['pathPrefix_img',   'string',  '', 'Path prefix for menu images.>>This string will be added for all image paths in the menu.'],
    ['pathPrefix_link',  'string',  '', 'Path prefix for menu links.>>This string will be added for all links in the menu.'],

    ['','separator','',''],

    ['smShowPause', 'integer-nn', '200',  'When mouse pointer is over the menu item - a delay (in ms) after that submenu will be shown.'],
    ['smHidePause', 'integer-nn', '1000',  'A delay (in ms) between mouse is moved from submenu and its closing.'],
    ['smSmartScroll', 'boolean', '1', 'Enables/disables smart scrolling of big submenus.>>0 - disabled, 1 - enabled (default).'],
    ['smHideOnClick', 'boolean', '1', 'Hides submenus on item click.>>0 - disabled, 1 - enabled (default).'],

    ['','separator','',''],

    ['dm_writeAll', 'boolean', '0', 'It\'s recommended to set this parameter to 1 when you\'re modifying your menu \'on-the-fly\' using Javascript API (var&nbsp;dynamic=1).>>Set it to 0 if you have a big menu - it\'ll increase loading speed.>>Default is 0.'],

  ['AJAX-like Technology','section','icon_ajax',''],
    ['dmAJAX',      'boolean', '0', 'AJAX-like technology allows to load data for submenus \'on-the-fly\' from the server.>>It\'s necessary to set exact value for var dmAJAXCount when using this technology.>>0 - disabled (default), 1 - enabled.>>Supported browsers (Windows OS):>>IE5+, Firefox, Mozilla, Netscape 7+, Opera 8+.'],
    ['dmAJAXCount', 'integer', '0', 'Maximal number of submenus that will be loaded from server.>>Default is 0. '],


  ['Dynamic Menu','section','icon_dynamic',''],
    ['dynamic', 'boolean', '0', 'Dynamic functions support.>>Deluxe Menu has external Javascript functions that allow you to change the menu \'on the fly\'.>>To enable dynamic functions set this parameter to 1.>>Dynamic functions are placed in dmenu_dyn.js file.'],

  ['Keystrokes Support','section','icon_keystrokes',''],
    ['keystrokes', 'boolean', '0', 'Keystrokes support.>>0 - disabled (default), 1 - enabled.>>Ctrl+F2 - enter the menu/switch to next menu on the page.>>Arrow keys - navigate.>>Enter - activate items.>>Esc - exit the menu.>>>>Notice: keystrokes don\'t work in Deluxe Tuner (Windows exe-application), they will work in a browser.'],
    ['dm_focus',   'boolean', '1', 'Show focus selection for selected item.'],
    ['dm_actKey',  'integer-nn', '113',  'Key code for keystrokes activation.>>Works with Ctrl key only.>>Default value is 113 = F2 key.>>114 = F3 key>>115 = F4 key>>etc.'],

];

onload = dm_initialize;
